
'*******************************************************************************
'* NET-IO+ Board for Atmega 32 - 1284P and ENC28J60      'SVN Rev.227 09.01.2011
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'    tfv
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'
'*******************************************************************************


'Please read HOW_TO_INSTALL.TXT
'There are a few very important hints


'*******************************************************************************
'*** SET NETIO SYSTEM SETTINGS
'*******************************************************************************
'$regfile = "m32def.dat"                                     'Chip =23
'$regfile = "m644def.dat"                                    'Chip =37 freesol alt
'$regfile = "m644pdef.dat"                                   'Chip =59
$regfile = "m1284pdef.dat"                                  'Chip =103 freesol neu
'(
* AT-MEGA 32    = m32def.dat
* AT-MEGA 644   = m644def.dat
* AT-MEGA 644P  = m644pdef.dat
* AT-MEGA 1284P = m1284pdef.dat
')
Const I_want_to_flash_fusebits = 0
'(
      You Can Do This One Time , To Set Right Fuses.
      It Is Recomended , If You Came Along With Orig Net -io M32 And Orig Firmware!
      After First Rebuild And Flash , Set It To "0"
')
Const My_crystal = 1
'(
* 1 = 16MHz  original NET-IO Modul, without any changes
* 2 = 20MHz  XTAL changed to 20MHz version
')
Const My_baudrate = 1
'(
      Baudrate On Serial Port
* 1 = 9600Bd
* 2 = 19200Bd
* 3 = 38400Bd
* 4 = 57600Bd
')
Const Netio_mode = 90
'(
   Mode Function
    1 - Webserver With Arp , Icmp , Tcp , Ip , Dns , Ntp , Udp , Http
         Mode For Mega32(don`t Use It With Higher Processor Units! Reduced Paket Sizes!)
         Site Content Is Build In Special Mode! See Http_routines.inc

    2 - Aufruf Einer Php Seite Und Abspeichern Von Temperaturen Mit At -mega 32
        Setup Der Php Seite Und Weitere Daten ber Beiliegendes Programm : Netio_setup.exe

    3 - Webserver With Arp , Dhcp , Dns , Ntp , Udp , Tcp
          With Lcd Display

    4 - Webserver
          Arp , Dhcp , Dns , Ntp , Udp , Tcp , Telnet , Sdcard , Ajax , Javascript
          With Lcd Display

    5 - Cam -temp -webserver
          Arp , Dhcp , Dns , Ntp , Udp , Tcp , Telnet , Sdcard , Ajax , Javascript
          With Lcd Display

    6 - Netio , Add -on Board , Cam , I2c Display Svg


    7 - Smtp(email) Client With Arp , Dhcp , Dns , Ntp , Udp , Tcp , Smtp
          With Lcd Display ! Keine Sdcard

   90 - Fr Freesol: Smtp(email) Client With Arp , Dhcp , Dns , Ntp , Udp , Tcp , Smtp, Javascript, SVG
          Kein Lcd Display ! Keine Sdcard

          Das Paket dient zur Anlagenberwachung und datenupload einer Solaranlage. Die Daten kommen aus dem S0-Signal eines Stromzhlers,
          werden von sonnenertrag.eu hochgeladen und sind auch direkt im Webserver visualisierbar. Einmal tglich wird eine Statusmail verschickt.

          Weitere Informationen zum Projekt unter ... und in den Threads

          Die berarbeitung basiert auf dem Paket "smtp NETIO+_SVN_Rev227.zip" (Posting HansHans vom 13.1.2011 im Bascom Board)

          Folgende Files sind im Paket neu eingefgt:
          * Neue Funktionen fr die (freesol_declarations.inc, freesol_routines.bas)

          Folgende Originalroutinen wurden verndert:
          * Im Hauptprogramm
               + Neuen Netio-Mode 90 eingefhrt fr Freesol
               + Anpassung von Compilerconstanten (I_want_to_flash_fusebits, My_baudrate, Netio_mode)
               + Ports B.2 Und D.4 Fr S0-Signal (Eingang) und Led-Anzeige (Ausgang) definiert
               + INT0 fr Verarbeitung des S0-Signals definiert
               + einige globale Variablen definiert, alle globalen Freesol-Variablen beginnen mit fs_
          * In Mega_setup.inc
               + Include_anwendung = 2 fgt Freesol_declarations.inc ein
* In http_routines.inc
                + Funktionen Verndert Fr Eigene Inhalte(http_m32_content , Javascript , Svg)
               + netio-Mode 90 bei verschiedenen Compileroptionen eingefgt
          * In ntp_routines.inc
               + Zusatzzeilen Fr Speicherung Der Startzeit Und Verbindungszeit Mit Ntp -server Eingefgt
          * smtp_routines_V4.inc
                + Mailinhalt Und Mailaufruf Gendert

          Weitere Infos auch in changelog_Freesol.txt und bei www.freesol.de

')

   $include "system_settings.inc"
   $hwstack = 250
   $swstack = 350
   $framesize = 200

'*******************************************************************************
'  Debugging !!!DEBUGING MAY CAUSE SRAM OVERFLOW!!!
'*******************************************************************************
Const Debug_ip = 0                                          '0 = off, 1 = compile header dumps
Const Debug_arp = 0                                         '0 = off, 1 = pkg rcv/sent, 2 = special, 3 = full dump
Const Debug_icmp = 0                                        '0 = off, 1 = pkg rcv/sent, 2 = special, 3 = full dump
Const Debug_udp = 0                                         '0 = off, 1 = compile header dumps
Const Debug_dhcp = 0                                        '0 = off, 1 = pkg rcv/sent, 2 = special, 3 = full dump
Const Debug_ntp = 0                                         '0 = off, 1 = pkg rcv/sent, 2 = special, 3 = full dump
Const Debug_dns = 0                                         '0 = off, 1 = pkg rcv/sent, 2 = special, 3 = full dump
Const Debug_tcp = 0
Const Debug_http = 0                                        '0 = off, 1 = only connect, 2 = flags connection, 3 = HTTP-Stack, 4 = full dump
Const System_message = 1
Const Debug_temp = 0                                        '0 = off, 1 = only connect, 2 = flags connection, 3 = HTTP-Stack, 4 = full dump
Const Debug_cam = 0                                         '0 -> no messages 1 -> chatter 2 -> important message (ie. fault on file system)
Const Debug_php_call = 0
Const Debug_smtp = 1                                        '0 = off, 1 to 4  on
Const Debug_freesol = 0                                     '0 = off, 1 on


'*******************************************************************************
'  Local Declarations
'*******************************************************************************
Dim My_s12_hostname As String * 12
Dim My_b_macaddr(6) As Byte
Dim My_b_ipaddr(4) As Byte
Dim My_b_ipaddr_l As Long At My_b_ipaddr(1) Overlay
Dim My_b_subnetmask(4) As Byte
Dim My_b_subnetmask_l As Long At My_b_subnetmask(1) Overlay
Dim My_b_subnet(4) As Byte
Dim My_b_defaultgateway(4) As Byte
Dim My_b_defaultgateway_l As Long At My_b_defaultgateway(1) Overlay


Dim Netio_time As Long
Dim New_second As Bit
Dim ___rseed As Word
Dim Running As Long

' Freesol
Dim Fs_i As Integer
Dim Fs_stundenwerte(24) As Long                             ' Die Werte fr die erste Stunde im Index 1
Dim Fs_stundenstart(24) As Long                             ' Startwert fr die erste Stunde in Index 1
For Fs_i = 1 To 24
   Fs_stundenwerte(fs_i) = 0
Next Fs_i
Dim Fs_startzeit_ntp As String * 30
Fs_startzeit_ntp = "unbelegt"
Dim Fs_startzeit_offset As String * 30
Dim Fs_tageswerte(100) As Integer                           ' Spiegelvariable fr eram, in 10 Wh
                                                              ' Achtung: Der ursprnglich fr Index  gedachte wert liegt jetzt in 100
For Fs_i = 1 To 100
   Fs_tageswerte(fs_i) = 0
Next Fs_i
Dim Fs_speicherdatum_tage As Long
Dim Fs_monatswerte As Long                                  ' Spiegelvariable fr eram, in Wh
Dim Fs_speicherdatum_monate As Long
Dim Fs_lfdmonwerte As Long                                  ' Spiegelvariable fr eram, in Wh
Dim Fs_speicherdat_lfdmon As Long
Dim Fs_minw(216) As Integer
Dim Fs_minw_vt(216) As Integer
Dim Fs_akt_leist As Single
Dim Fs_akt_leist_min As Single
Dim Fs_tagertr_min As Long
For Fs_i = 1 To 216
  Fs_minw(fs_i) = 0
Next Fs_i
Dim Fs_minlast As Long
Dim Fs_minlast_min As Long
Dim Fs_minpos As Integer
Dim Fs_min_i As Integer
Fs_min_i = 1
Dim Fs_min_j As Integer
Fs_min_j = 1
Fs_minlast = 0
Dim Fs_pulszahl As Long
Dim Fs_ledflag As Bit
Fs_pulszahl = 0
Dim Fs_mail_datum As String * 10
Dim Fs_mail_energie As Single                               ' Energie in Wh
Dim Fs_mail_energienorm As Single
Dim Fs_anlagenleistung As Integer                           'Anlagenleistung in Whp
Fs_anlagenleistung = 10000
Dim Fs_version As String * 12
Fs_version = "2.04.02"
Dim Fs_tagesmax As Integer
Dim Fs_ersteraufruf As Byte
Fs_ersteraufruf = 0
Const Fs_debugvar = 1                                       '1: eeram wird gelesen; 2 eeram wird gelscht, 3 eeram wird mit dummy vorbelegt
Dim Fs_string As String * 50
Dim Fs_pulszahlges As Long
Dim Fs_pulsfaktor As Integer
Dim Fs_lcd As Byte
Dim Fs_lcd_letzte_pulszahl As Long
Fs_lcd_letzte_pulszahl = 0
Dim Fs_lcd_diese_pulszahl As Long
Fs_lcd_diese_pulszahl = 0
Dim Fs_maildebugflag As Byte
Dim Fs_schaltschwelle As Integer
Dim Fs_alarmmailtext As String * 39
Dim Fs_schaltdauer As Integer
Dim Fs_schaltdauertemp As Integer
Fs_schaltdauertemp = 0
Dim Fs_mailstatus As Integer                                ' 0 wenn keine Mail anliegt, 1 wenn normale tagesmail anliegt, 2 wenn Alarmmail anliegt
Fs_mailstatus = 0
Dim Fs_alarmmailflag2 As Byte
Fs_alarmmailflag2 = 1
Dim Fs_speicherdatum_minuten As Long
Dim Fs_lcd_timer As Integer
Fs_lcd_timer = 0
Dim Fs_lcdstring As String * 17
Dim Fs_lcdsing As Single
Dim Fs_lcdsing2 As Single
Dim Fs_dhcp As Integer

'fr sml
Dim Fs_bezug As Single                                      'in kWh mit Nachkommastellen
Dim Fs_einspeis As Single                                   'in kWh mit Nachkommastellen
Dim Fs_bezug_l As Long                                      'in Wh
Dim Fs_einspeis_l As Long                                   'in Wh
Dim Fs_smllesezeit As String * 30
Dim Fs_sml(500) As Byte                                     'Werte gespeichert ab Index 1
Dim Fs_smlsuch(20) As Byte                                  'Werte gespeichert ab Index 1
Dim Fs_smlaz As Integer
Dim Fs_smlsuchaz As Integer
Dim Fs_meldung As String * 30
Dim Fs_loggertyp As String * 30
Dim Fs_bezug_tagesstand(30) As Long                         ' Spiegelvariable fr eram, in Wh
For Fs_i = 1 To 30
   Fs_bezug_tagesstand(fs_i) = 0
Next Fs_i
Dim Fs_bezug_tagesstart As Long
Dim Fs_bezug_speichdat_t As Long
Dim Fs_einspeis_tagesstand(30) As Long                      ' Spiegelvariable fr eram, in Wh
For Fs_i = 1 To 30
   Fs_einspeis_tagesstand(fs_i) = 0
Next Fs_i
Dim Fs_einspeis_tagesstart As Long
Dim Fs_einspeis_speichdat_t As Long
Dim Fs_sml_tagesw_gespeichert As Integer
Dim Fs_min_bezug(288) As Integer                            ' 5min-Werte (Differenz zum Vorwert in Wh)
Dim Fs_min_einspeis(288) As Integer
Dim Fs_min_bezug_vt(288) As Integer                         ' 5min-Werte (Differenz zum Vorwert in Wh)
Dim Fs_min_einspeis_vt(288) As Integer
Dim Fs_bezug_l_alt As Long                                  'Zhlerstand des letzten 5min-Wertes in Wh
Dim Fs_einspeis_l_alt As Long                               'Zhlerstand des letzten 5min-Wertes in Wh
Dim Fs_bezug_l_alt1 As Long                                 'Zhlerstand des letzten 1min-Wertes in Wh
Dim Fs_einspeis_l_alt1 As Long                              'Zhlerstand des letzten 1min-Wertes in Wh
Dim Fs_minpos_bez As Integer
Dim Fs_speichdat_vt_t As Long
Dim Fs_ev_url As String * 12

Dim Fn1 As String * 12
Dim Fn2 As String * 12
Dim Fn3 As String * 12
Dim Fn4 As String * 12
Dim Fn5 As String * 12
Dim Fn6 As String * 12
Dim Fn7 As String * 12
Dim Fn8 As String * 12
Dim Fn9 As String * 12
Dim Fn10 As String * 12
Dim Fn11 As String * 12
Dim Fn12 As String * 12
Dim Fs_crccalc As Word
Dim Fs_crcstore As Word
Dim Fs_crcfehlerzahl As Integer
Fs_crcfehlerzahl = 0
Dim Fs_smllesezahl As Integer
Fs_smllesezahl = 0



                               'Funktioniert nur bei debug_freesol=1
                                                            'Fs_debugvar = 1 Eprom lesen und ber RS232 anzeigen
                                                            'Fs_debugvar = 2 Eprom Freesol Werte lschen
                                                            'Fs_debugvar = 3 Debug.js anzeigen
' Freesol Ende

$include "mega_setup.inc"

'*******************************************************************************
'  Config Watchdog
'*******************************************************************************
Config Watchdog = 2048                                      'reset after 2048 mSec
   Start Watchdog
   Reset Watchdog


'*******************************************************************************
'  Config Clock
'*******************************************************************************
Netio_time = 0
Config Date = Dmy , Separator = .
Config Clock = User
#if My_crystal = 1
   Const Reload = 62500
   Config Timer1 = Timer , Prescale = 256
#endif
#if My_crystal = 2
   Const Reload = 19530                                     '= 1s
   Config Timer1 = Timer , Prescale = 1024
#endif
   Ocr1ah = High(reload)
   Ocr1al = Low(reload)
   Tccr1a = 0
   Set Tccr1b.3
On Compare1a Isr_timer1


'*******************************************************************************
'  Hardware Port Settings
'*******************************************************************************

Enc28j60_cs Alias Portb.4                                   'PortB.4 = CS Pin of the ENC28J60
Config Enc28j60_cs = Output
Set Enc28j60_cs

Enc28j60_int Alias Portb.2                                  'PortB.2 = INT Pin of the ENC28J60
Config Enc28j60_int = Input
   Enc28j60_int = 1                                         'Pullup
Config Int2 = Falling                                       'Wichtig fr 644 / 644P
On Int2 Isr_int2

Call Activate_enc28j60

' Freesol
Config Int0 = Falling
Config Pind.2 = Input
'Portd = &B00011100                                          ' Im Port D sind 2,Ausgang, der Rest eingang   (0 ist Eingang, 1 ist ausgang
Portd = &B00000100                                          ' Das sidn glaub ich die Pullups Im Port D sind 2,hochgezogen
On Int0 Fs_s0_interrupt

Fs_s0_int Alias Portb.2                                     'PortB.2 = S0-Signal als Eingang, liegt auf Pin 10 des Extern-Steckers
Config Fs_s0_int = Input
Fs_s0_int = 1                                               'Pullup

Fs_led_int Alias Portd.4                                    'PortD.4 = LED Ausgangssignal zu Anzeige eines S0-Signals, liegt auf Ppin 8 des Extern-Steckers
Config Fs_led_int = Output
Fs_led_int = 0

Fs_schaltsignal Alias Portd.3                               'PortD.3 = Schaltsignal fr externe Steckdose, liegt auf Pin 2 des Extern-Steckers
Config Fs_schaltsignal = Output
Fs_schaltsignal = 0

Fs_alarmmailflag Alias Pind.5                               'PortD.5 = Eingang fr Alarmmail, 1 sendet mail, liegt auf Pin 4 des Ext steckers
Config Fs_alarmmailflag = Input
Portd.5 = 1
' Freesol Ende


#if Netio_mode = 1
'Special settings for M32 Mode
     Ddra = &B0000_0000
     Config Porta = Input
     Porta = &H0F
     Ddrc = &B1111_1111
     Config Portc = Output
     Config Adc = Single , Prescaler = Auto
     Start Adc
#endif


'*******************************************************************************
'  Initialize variables from EERAM
'*******************************************************************************
   Call Eeram_setup_network

'*******************************************************************************
'  Start main program
'*******************************************************************************
#if System_message = 1
   Print "Starting FreeSol " ; Fs_version
   Print " on Chip: " ; Processor ; " (Chip=" ; _chip ; ")"
   Print "(Compiled at: " ; Version(1) ; ")"
   Print "----------------------------------"
#endif

'*******************************************************************************
'  Reset and initialize the Enc28J60
'*******************************************************************************
   Call Enc28j60_init

'*******************************************************************************
'  alea iacta est :-)   sets an individual startvalue for random generator
'*******************************************************************************
   ___rseed = Crc16(my_b_macaddr(1) , 6)

'*******************************************************************************
'  ARP Call Important first time
'*******************************************************************************
   Call Arp_first_init

'*******************************************************************************
'  Config Temperature Sensors
'*******************************************************************************
#if Include_temperatur > 0
   Call Temp_initialize
#endif
   Reset Watchdog

'*******************************************************************************
'  Config SD-CARD Filesystem
'*******************************************************************************
#if Include_sdcard > 0
   Call Sdcard_initialize
#endif

'*******************************************************************************
'  Config CAM
'*******************************************************************************
#if Include_cam > 0
   Call Cam_initialize
#endif

'*******************************************************************************
'  DHCP
'*******************************************************************************
#if Include_dhcp = 1
' Freesol-Ergnzung
   Fs_dhcp = Ee_fs_dhcp
   If Fs_dhcp <> 1 Then
      Call Dhcp_initialize
   End If
#endif

'*******************************************************************************
   'Enable interrupts
'*******************************************************************************
   Enable Compare1a                                         'enable timer1 interrupt (Clock Interrupt)
' Freesol
   Enable Int0                                              'enable interrupt 0 (S0-Signal Interrupt fr Freesol)
' Freesol Ende
   Enable Int2                                              'enable interrupt 2 (ENC28J60 Interrupt)
   Enable Interrupts


'*******************************************************************************
   'I2C Bus starten
'*******************************************************************************
   Config Scl = Portd.6                                     ' Ports fuer IIC-Bus, nicht Standard !
   Config Sda = Portb.0

   I2cinit


'*******************************************************************************
' Start main loop
'*******************************************************************************
   Do
      If Enc28j60_data_present = 1 Then
         Enc28j60_data_present = 0
         Call Enc28j60disableinterrupt
         Call Handle_enc28j60packet                         'work out the packet
         Call Enc28j60enableinterrupt
      Else
         #if Include_http = 1
          If Http_stack_flag > 0 Then
            Call Paket_senden
          End If
         #endif

         #if Include_rs232_setup > 0
           Call Php_rs232
         #endif


        'Freesol
         #if Include_anwendung = 2
            If Fs_ledflag = 1 Then
               Fs_ledflag = 0
            Fs_led_int = 1
            Waitms 10
            ' Print "S0-Puls empfangen: " ; Pulszahl
            Fs_led_int = 0
            End If
         #endif
         'Freesol Ende


         If New_second = 1 Then
            New_second = 0
            Reset Watchdog

            #if Include_lcd = 1 Or Include_lcd = 5
                If _sec = 0 Then Cls
            #endif

            #if Include_http = 1
                 Call Http_stack_life
            #endif

            #if Include_php_call > 0
              Call Php_compute
            #endif

            #if Include_cam > 0
              Call Cam_compute
            #endif

            #if Include_lcd = 1 Or Include_lcd = 5
             ' Update_clock on LCD
             Locate 2 , 8
             Lcd Time(netio_time)
            #endif

            #if Include_lcd = 6
              If Fs_lcd = 2 Then
                  Call Fs_lcd_display
              End If
            #endif
            #if Include_anwendung = 1
             ' Update_Hans
              Gosub Label_anw_rout_every_sec
            #endif

            Select Case _sec

               Case 5:
                     #if Include_ntp = 1
                        Call Ntp_every_minute
                     #endif
               Case 7:
                    #if Include_smtp = 1
                        Gosub Smtp_inc_by_main_loop_7
                     #endif
               Case 10:
                     #if Include_dhcp = 1
                        If Fs_dhcp <> 1 Then
                           Call Dhcp_every_minute
                        End If
                     #endif
               Case 15:
                     #if Include_arp = 1
                        Call Arp_every_minute
                     #endif

               #if Include_sml = 1
               Case 22:
                     Call Fs_smllesen
               #endif

               'Freesol
               #if Include_anwendung = 2
               Case 32:
                     Call Fs_freesol_update
               #endif
               'Freesol Ende




               Case 42
                     If Fs_lcd = 1 Then
                        Call Fs_lcd_update_3seg
                     End If

               Case 48:
                    #if Include_smtp = 1
                       Gosub Smtp_inc_by_main_loop_48
                    #endif

               Case 50:
                     #if Include_temperatur > 0
                        #if Include_http = 1
                        If Http_stack_flag = 0 Then
                        #endif
                           Call Get_temp
                        #if Include_http = 1
                        End If
                        #endif
                     #endif
               Case Else
            End Select

         End If
      End If
   Loop

'*******************************************************************************
' End main loop
'*******************************************************************************
End                                                         'for compiler

Fcstab:
Data &H0% , &H1189% , &H2312% , &H329B% , &H4624% , &H57AD% , &H6536% , &H74BF% , &H8C48%
Data &H9DC1% , &HAF5A% , &HBED3% , &HCA6C% , &HDBE5% , &HE97E% , &HF8F7% , &H1081% , &H108% , &H3393% , &H221A% , &H56A5% , &H472C%
Data &H75B7% , &H643E% , &H9CC9% , &H8D40% , &HBFDB% , &HAE52% , &HDAED% , &HCB64% , &HF9FF% , &HE876% , &H2102% , &H308B% , &H210%
Data &H1399% , &H6726% , &H76AF% , &H4434% , &H55BD% , &HAD4A% , &HBCC3% , &H8E58% , &H9FD1% , &HEB6E% , &HFAE7% , &HC87C% , &HD9F5%
Data &H3183% , &H200A% , &H1291% , &H318% , &H77A7% , &H662E% , &H54B5% , &H453C% , &HBDCB% , &HAC42% , &H9ED9% , &H8F50% , &HFBEF%
Data &HEA66% , &HD8FD% , &HC974% , &H4204% , &H538D% , &H6116% , &H709F% , &H420% , &H15A9% , &H2732% , &H36BB% , &HCE4C% , &HDFC5%
Data &HED5E% , &HFCD7% , &H8868% , &H99E1% , &HAB7A% , &HBAF3% , &H5285% , &H430C% , &H7197% , &H601E% , &H14A1% , &H528% , &H37B3%
Data &H263A% , &HDECD% , &HCF44% , &HFDDF% , &HEC56% , &H98E9% , &H8960% , &HBBFB% , &HAA72% , &H6306% , &H728F% , &H4014% , &H519D%
Data &H2522% , &H34AB% , &H630% , &H17B9% , &HEF4E% , &HFEC7% , &HCC5C% , &HDDD5% , &HA96A% , &HB8E3% , &H8A78% , &H9BF1% , &H7387%
Data &H620E% , &H5095% , &H411C% , &H35A3% , &H242A% , &H16B1% , &H738% , &HFFCF% , &HEE46% , &HDCDD% , &HCD54% , &HB9EB% , &HA862%
Data &H9AF9% , &H8B70% , &H8408% , &H9581% , &HA71A% , &HB693% , &HC22C% , &HD3A5% , &HE13E% , &HF0B7% , &H840% , &H19C9% , &H2B52%
Data &H3ADB% , &H4E64% , &H5FED% , &H6D76% , &H7CFF% , &H9489% , &H8500% , &HB79B% , &HA612% , &HD2AD% , &HC324% , &HF1BF% , &HE036%
Data &H18C1% , &H948% , &H3BD3% , &H2A5A% , &H5EE5% , &H4F6C% , &H7DF7% , &H6C7E% , &HA50A% , &HB483% , &H8618% , &H9791% , &HE32E%
Data &HF2A7% , &HC03C% , &HD1B5% , &H2942% , &H38CB% , &HA50% , &H1BD9% , &H6F66% , &H7EEF% , &H4C74% , &H5DFD% , &HB58B% , &HA402%
Data &H9699% , &H8710% , &HF3AF% , &HE226% , &HD0BD% , &HC134% , &H39C3% , &H284A% , &H1AD1% , &HB58% , &H7FE7% , &H6E6E% , &H5CF5%
Data &H4D7C% , &HC60C% , &HD785% , &HE51E% , &HF497% , &H8028% , &H91A1% , &HA33A% , &HB2B3% , &H4A44% , &H5BCD% , &H6956% , &H78DF%
Data &HC60% , &H1DE9% , &H2F72% , &H3EFB% , &HD68D% , &HC704% , &HF59F% , &HE416% , &H90A9% , &H8120% , &HB3BB% , &HA232% , &H5AC5%
Data &H4B4C% , &H79D7% , &H685E% , &H1CE1% , &HD68% , &H3FF3% , &H2E7A% , &HE70E% , &HF687% , &HC41C% , &HD595% , &HA12A% , &HB0A3%
Data &H8238% , &H93B1% , &H6B46% , &H7ACF% , &H4854% , &H59DD% , &H2D62% , &H3CEB% , &HE70% , &H1FF9% , &HF78F% , &HE606% , &HD49D%
Data &HC514% , &HB1AB% , &HA022% , &H92B9% , &H8330% , &H7BC7% , &H6A4E% , &H58D5% , &H495C% , &H3DE3% , &H2C6A% , &H1EF1% , &HF78%
'Wichtig: Das erste Element eines Arrays in BASCOM-AVR hat immer den Index 1
' ABER: Lookup beginnt bei 0!


'*******************************************************************************
'  INT0 Interrupt (PortD.2 = S0-Signal-Interrupt    )
'*******************************************************************************
Fs_s0_interrupt:
   Incr Fs_pulszahl
   Fs_ledflag = 1
   'Print Date$ ; "  " ; Time$ ; "  " ; fs_Pulszahl
   Return

'*******************************************************************************
'  INT2 Interrupt (PortB.2 = ENC28J60 Interrupt    )
'*******************************************************************************
Isr_int2:
  Enc28j60_data_present = 1
  Return

'*******************************************************************************
'  TIMER1 Interrupt (called every second)
'*******************************************************************************
Isr_timer1:
   Incr Netio_time
   Time$ = Time(netio_time)
   Incr Running
   New_second = 1
Return

'*******************************************************************************
'  ECHTZEITUHR STELLEN (derzeit kein Bestandteil von NET-IO)
'   for set clock = user
'   Einsprungadresse um nach TIME$ = xxxx z.B. eine Echtzeituhr zu stellen!
'*******************************************************************************
Getdatetime:
Return

Settime:
Return

Setdate:
Return

'*******************************************************************************
'  Protocol specific routines
'*******************************************************************************
$include "eeram_routines.inc"                               '

#if Include_enc28j60 > 0
    $include "ENC28J60_routines.inc"                        ' the ENC28J60-routines
#endif

#if Include_ip > 0
    $include "ip_routines.inc"
#endif
#if Include_arp > 0
    $include "arp_routines.inc"
#endif
#if Include_icmp > 0
    $include "icmp_routines.inc"
#endif
#if Include_udp > 0
    $include "udp_routines.inc"
#endif
#if Include_ntp > 0
    $include "ntp_routines.inc"
#endif
#if Include_dhcp > 0
    $include "dhcp_routines.inc"
#endif
#if Include_dns > 0
    $include "dns_routines.inc"
#endif
#if Include_tcp > 0
    $include "tcp_routines.inc"
#endif
#if Include_http > 0
    $include "http_routines.inc"
#endif
#if Include_php_call > 0
    $include "php_call_routines.inc"
#endif
#if Include_telnet > 0
    $include "telnet_routines.inc"
#endif
#if Include_sdcard > 0
    $include "sd-card_routines.inc"
#endif
#if Include_temperatur > 0
    $include "temperatur_routines.inc"
#endif
#if Include_cam > 0
    $include "cam_routines.inc"
#endif
#if Include_rs232_setup = 1
    $include "rs232_setup_routines.inc"
#endif
#if Include_smtp > 0
   $include "smtp_routines_V4.inc"
#endif



#if Include_anwendung = 1
    $include "anwendung_routines.inc"
#endif
#if Include_anwendung = 2
    $include "freesol_routines.inc"
#endif




$include "misc_routines.inc"

#if Netio_mode <> 1 And Include_http > 0 And Include_sdcard = 0
   'Statische Seiteninhalte, wenn keine SD-Card vorghanden
   $inc 404 , Size , "site/simple/404.htm"
#endif